#####################################################################################
#                   Ratification rates & Signature-ratfication differences           
#####################################################################################

TAB.descr <- read.csv("D:/CbT-replication/DescStat_Country.csv")
str(TAB.descr, list.len=ncol(TAB.descr))
TAB.descr$ISO_alpha <- as.character(TAB.descr$ISO_alpha)      

# US
No.Rat.US <- TAB.descr$N.Rat[TAB.descr$ISO_alpha=="USA"]
No.Rat.US

No.Diff.US <- TAB.descr$N.Rat.2[TAB.descr$ISO_alpha=="USA"]-TAB.descr$N.Sig[TAB.descr$ISO_alpha=="USA"]
No.Diff.US

# G8-US
No.Rat.G8woUS <- mean(TAB.descr$N.Rat[TAB.descr$G8==1])
No.Rat.G8woUS

No.Diff.G8woUS <- mean(TAB.descr$N.Rat.2[TAB.descr$G8==1]-TAB.descr$N.Sig[TAB.descr$G8==1])
No.Diff.G8woUS

# G20-(EU&US)
No.Rat.G20woUS <- mean(TAB.descr$N.Rat[TAB.descr$G20==1])
No.Rat.G20woUS

No.Diff.G20woUS <- mean(TAB.descr$N.Rat.2[TAB.descr$G20==1]-TAB.descr$N.Sig[TAB.descr$G20==1])
No.Diff.G20woUS

# non-G20
No.Rat.nonG20 <- mean(TAB.descr$N.Rat[TAB.descr$G20==0 & TAB.descr$ISO_alpha!="USA"])
No.Rat.nonG20

No.Diff.nonG20 <- mean(TAB.descr$N.Rat.2[TAB.descr$G20==0 & TAB.descr$ISO_alpha!="USA"], na.rm=TRUE)-mean(TAB.descr$N.Sig[TAB.descr$G20==0 & TAB.descr$ISO_alpha!="USA"], na.rm=TRUE)
No.Diff.nonG20

######################################################################################################################
######################################################################################################################

TAB.replic <- read.csv("D:/CbT-replication/CbT_data.csv")
str(TAB.replic, list.len=ncol(TAB.replic))
TAB.replic$ISO_alpha <- as.character(TAB.replic$ISO_alpha)      
TAB.replic$treaty_abb <- as.character(TAB.replic$treaty_abb)                         

# Trade-independence 
TAB.replic$independence_i_USA <- 1 -(TAB.replic$tradeshare_i_USA - TAB.replic$tradeshare_USA_i)
 
str(TAB.replic, list.len=ncol(TAB.replic)) 

# Treaty sample 
sort(unique(TAB.replic$treaty_abb))
test <- aggregate(rep(1,nrow(TAB.replic)),FUN=sum,by=list(TAB.replic$treaty_abb))
colnames(test)[1:2] <- c("treaty_abb", "N")
subset(test, test$treaty_abb=="CUN")

adop <- unique(subset(TAB.replic, select=c(treaty_abb,treaty_adopted))) 
order(adop)
adop[ order(adop$treaty_adopt), ]

# US ratfied and non-ratfied treaties 
vec.treaty.rat.USA <- TAB.replic$treaty_abb[TAB.replic$status==1 & TAB.replic$ISO_alpha=="USA"]
TAB.replic$USratif.dum <- 0
TAB.replic$USratif.dum[TAB.replic$treaty_abb %in% vec.treaty.rat.USA] <- 1
unique(TAB.replic$treaty_abb[TAB.replic$USratif.dum==0])
unique(TAB.replic$treaty_abb[TAB.replic$USratif.dum==1])

# Drop US
TAB.replic <- subset(TAB.replic, TAB.replic$ISO_alpha!="USA")  


# Subset of treaties 
select.treaties <- c("VCLT","C100","C105","C111","C138","C182","C87","C98",                                        
                      "GC","APGC","APIIGC","OPIICRC","ICRMW",                                                
                      "CERD","ICESCR","ICCPR","OPICCPR","OPIIICCPR","CEDAW","OPCEDAW","CAT","CRC","OPCRC",   
                      "CBD","CPCBD","MP","UNFCCC","KPCC","BC","RC","SC","PGRT","UNCCD","UNCLS",              
                      "TFC","BWC","CWC","NPT","CTBT","APMC","RSICC",                                         
                      #"WTO","GATT","IMF","IBRD",                                                             
                      "OPICESCR","OPCAT","CRPD","OPCRPD","CAED","CCM","NTC",                                 
                      "UNCTOC","PIUNCTOC","PIIUNCTOC","PIIIUNCTOC","UNCC",                                   
                      "CUN","VCDR","VCIO",                                                                   
                      "CPPCG",
                      "CITES","CMS","VCPOL","PBC",                                                           
                      "TBC","PTBT","CCWCPIPIII","PIVCCWC","PVCCWC")                                          

TAB <- subset(TAB.replic, TAB.replic$treaty_abb %in% select.treaties)              
sort(unique(TAB$treaty_abb))

##################################################################################################################
#                                         Scatter plots (Power & Independence)                                    
##################################################################################################################
require(maptools)
Path.output <- "D:/CbT-replication/"
year <- sort(unique(TAB$stop.trunc))

# 2000
    Power.08.line <- quantile(TAB$power_ratUSA_positive[year==2000], probs = c(0.01,1), na.rm = TRUE)
    Independ.08.line <- quantile(TAB$independence_i_USA[year==2000], probs = c(0.01,1), na.rm = TRUE)

    TAB.temp <- subset(TAB, TAB$stop.trunc==2000)  
    TAB.temp <- aggregate(cbind(TAB.temp$power_ratUSA_positive,TAB.temp$independence_i_USA), by=list(TAB.temp$ISO_alpha), FUN=mean, na.rm=TRUE)
    colnames(TAB.temp)[1:3] <- c("ISO_alpha","power_ratUSA_positive","independence_i_USA")
    
    TAB.temp <- subset(TAB.temp, is.na(TAB.temp$power_ratUSA_positive)==FALSE & is.na(TAB.temp$independence_i_USA)==FALSE)
    
    x.lim <- c(min(TAB.temp$power_ratUSA_positive, na.rm=TRUE), max(TAB.temp$power_ratUSA_positive, na.rm=TRUE))
    y.lim <- c(min(TAB.temp$independence_i_USA, na.rm=TRUE), max(TAB.temp$independence_i_USA, na.rm=TRUE))
        
    par(mar=c(5,4,3,1)+0.1, las=1, mfrow=c(1,1))
    plot(NULL, NULL, xlim=(x.lim -0.001), ylim=y.lim, xlab="Power", ylab="Independence", main=2000)
    pointLabel(x=TAB.temp$power_ratUSA_positive, y=TAB.temp$independence_i_USA, labels = paste("  ", TAB.temp$ISO_alpha, "  ", sep="  "), cex=0.8)
        
    #outfile = paste(Path.output,"CountryPlot_PowIndep_2000.pdf", sep="")
    #dev.print(device = pdf, file=outfile)
    #outfile = paste(Path.output,"CountryPlot_PowIndep_2000.jpg", sep="")
    #dev.print(device = jpeg, file=outfile, width=1024, height=768)

# 1975
    Power.08.line <- quantile(TAB$power_ratUSA_positive[year==1975], probs = 0.8, na.rm = TRUE)
    Independ.08.line <- quantile(TAB$independence_i_USA[year==1975], probs = 0.8, na.rm = TRUE)

    TAB.temp <- subset(TAB, TAB$stop.trunc==1975)  
    TAB.temp <- aggregate(cbind(TAB.temp$power_ratUSA_positive,TAB.temp$independence_i_USA), by=list(TAB.temp$ISO_alpha), FUN=mean, na.rm=TRUE)
    colnames(TAB.temp)[1:3] <- c("ISO_alpha","power_ratUSA_positive","independence_i_USA")
    
    TAB.temp <- subset(TAB.temp, is.na(TAB.temp$power_ratUSA_positive)==FALSE & is.na(TAB.temp$independence_i_USA)==FALSE)
    
    x.lim <- c(min(TAB.temp$power_ratUSA_positive, na.rm=TRUE), max(TAB.temp$power_ratUSA_positive, na.rm=TRUE))
    y.lim <- c(min(TAB.temp$independence_i_USA, na.rm=TRUE), max(TAB.temp$independence_i_USA, na.rm=TRUE))
    
    par(mar=c(5,4,3,1)+0.1, las=1, mfrow=c(1,1))
    plot(NULL, NULL, xlim=(x.lim -0.001), ylim=y.lim, xlab="Power", ylab="Independence", main=1975)
    pointLabel(x=TAB.temp$power_ratUSA_positive, y=TAB.temp$independence_i_USA, labels = paste("  ", TAB.temp$ISO_alpha, "  ", sep="  "), cex=0.8)
       
    #outfile = paste(Path.output,"CountryPlot_PowIndep_1975.pdf", sep="")
    #dev.print(device = pdf, file=outfile)
    #outfile = paste(Path.output,"CountryPlot_PowIndep_1975.jpg", sep="")
    #dev.print(device = jpeg, file=outfile, width=1024, height=768)  

# 1950
    Power.08.line <- quantile(TAB$power_ratUSA_positive[year==1950], probs = 0.8, na.rm = TRUE)
    Independ.08.line <- quantile(TAB$independence_i_USA[year==1950], probs = 0.8, na.rm = TRUE)

    TAB.temp <- subset(TAB, TAB$stop.trunc==1950)  
    TAB.temp <- aggregate(cbind(TAB.temp$power_ratUSA_positive,TAB.temp$independence_i_USA), by=list(TAB.temp$ISO_alpha), FUN=mean, na.rm=TRUE)
    colnames(TAB.temp)[1:3] <- c("ISO_alpha","power_ratUSA_positive","independence_i_USA")
    
    TAB.temp <- subset(TAB.temp, is.na(TAB.temp$power_ratUSA_positive)==FALSE & is.na(TAB.temp$independence_i_USA)==FALSE)
    
    x.lim <- c(min(TAB.temp$power_ratUSA_positive, na.rm=TRUE), max(TAB.temp$power_ratUSA_positive, na.rm=TRUE))
    y.lim <- c(min(TAB.temp$independence_i_USA, na.rm=TRUE), max(TAB.temp$independence_i_USA, na.rm=TRUE))
    
    par(mar=c(5,4,3,1)+0.1, las=1, mfrow=c(1,1))
    plot(NULL, NULL, xlim=(x.lim -0.001), ylim=y.lim, xlab="Power", ylab="Independence", main=1950)
    pointLabel(x=TAB.temp$power_ratUSA_positive, y=TAB.temp$independence_i_USA, labels = paste("  ", TAB.temp$ISO_alpha, "  ", sep="  "), cex=0.8)
       
    #outfile = paste(Path.output,"CountryPlot_PowIndep_1950.pdf", sep="")
    #dev.print(device = pdf, file=outfile)
    #outfile = paste(Path.output,"CountryPlot_PowIndep_1950.jpg", sep="")
    #dev.print(device = jpeg, file=outfile, width=1024, height=768)

##################################################################################################################
#                                             Survival models                                                     
##################################################################################################################
library(survival)

# Model 1
Fit.1 <- coxph( Surv(TAB$start,TAB$stop,TAB$status)~
                        power_ratUSA_positive 
                        +independence_i_USA 
                        +power_ratUSA_positive*independence_i_USA 
                        +cluster(ISO_alpha),data=TAB)
        summary(Fit.1)
            # no. of countries
            temp.a <-   subset(TAB, 
                            is.na(independence_i_USA)==FALSE &
                            is.na(power_ratUSA_positive)==FALSE 
                            )               
                        length(unique(temp.a$ISO_alpha))
             # period of analysis
                        min(temp.a$stop, na.rm=TRUE)    
                        max(temp.a$stop, na.rm=TRUE) 
        
# Model 2 
Fit.2 <- coxph( Surv(TAB$start,TAB$stop,TAB$status)~
                                power_ratUSA_positive
                                +independence_i_USA 
                                +power_ratUSA_positive*independence_i_USA
                                +p_polity2 
                                +state_tenure 
                                +factor(issues_new) 
                                +cluster(ISO_alpha) ,data=TAB)
        summary(Fit.2)
        # no. of countries
                        temp.a <-   subset(TAB, 
                             is.na(independence_i_USA)==FALSE &
                             is.na(power_ratUSA_positive)==FALSE &
                             is.na(p_polity2)==FALSE &
                             is.na(state_tenure)==FALSE &
                             is.na(issues_new)==FALSE
                            )               
                        length(unique(temp.a$ISO_alpha))
        # period of analysis
                        min(temp.a$stop, na.rm=TRUE)    
                        max(temp.a$stop, na.rm=TRUE)
                        
# Stratfied model
Fit.strata <- coxph( Surv(TAB$start,TAB$stop,TAB$status)~
                                power_ratUSA_positive 
                                +independence_i_USA +power_ratUSA_positive*independence_i_USA 
                                +p_polity2 
                                +state_tenure  
                                +factor(issues_new)
                                +strata(USratif.dum) 
                                +cluster(ISO_alpha),data=TAB)
        summary(Fit.strata)   
               # no. of countries
                        temp.a <-   subset(TAB, 
                             is.na(independence_i_USA)==FALSE &
                             is.na(power_ratUSA_positive)==FALSE &
                             is.na(p_polity2)==FALSE &
                             is.na(state_tenure)==FALSE &
                             is.na(issues_new)==FALSE &
                             is.na(USratif.dum)==FALSE 
                            )               
                        length(unique(temp.a$ISO_alpha))
                # period of analysis
                        min(temp.a$stop, na.rm=TRUE)    
                        max(temp.a$stop, na.rm=TRUE)

# Model 3
TAB.USAnorat <- subset(TAB, TAB$treaty_abb %in% c("OPIIICCPR","OPCEDAW","C98","VCIO","APGC","APIIGC","CTBT","PBC","CMS","BC",        
                                                        "ICESCR","CEDAW","C87","VCLT","OPICCPR","C100","C138","KPCC","CPCBD","SC",        
                                                        "PGRT","CRPD","RC","PIIIUNCTOC","ICRMW","UNCLS","APMC","NTC","C111","CRC",       
                                                        "OPCAT","RSICC","OPICESCR","CBD","CCM","CAED","OPCRPD" )) 
       
Fit.3 <- coxph( Surv(TAB.USAnorat$start,TAB.USAnorat$stop,TAB.USAnorat$status)~
                                power_ratUSA_positive 
                                +independence_i_USA 
                                +power_ratUSA_positive*independence_i_USA 
                                +p_polity2 
                                +state_tenure 
                                +factor(issues_new)
                                +cluster(ISO_alpha),data=TAB.USAnorat)
        summary(Fit.3)
            # no. of countries
                        temp.a <-   subset(TAB.USAnorat, 
                             is.na(independence_i_USA)==FALSE &
                             is.na(power_ratUSA_positive)==FALSE &
                             is.na(p_polity2)==FALSE &
                             is.na(state_tenure)==FALSE &
                             is.na(issues_new)==FALSE 
                            )               
                        length(unique(temp.a$ISO_alpha))
            # period of analysis
                        min(temp.a$stop, na.rm=TRUE)    
                        max(temp.a$stop, na.rm=TRUE)

# Model 4
TAB.USArat <- subset(TAB, TAB$treaty_abb %in% c("CWC","PIUNCTOC","C182","C105","PIVCCWC","TBC","CITES","CPPCG","OPCRC","PVCCWC",    
                                                    "ICCPR","MP","PIIUNCTOC","UNFCCC","VCPOL","GC","CCWCPIPIII","OPIICRC","CERD","CUN",       
                                                    "TFC","UNCTOC","VCDR","BWC","UNCCD","CAT","UNCC","NPT","PTBT" ))
       
Fit.4 <- coxph( Surv(TAB.USArat$start,TAB.USArat$stop,TAB.USArat$status)~
                                power_ratUSA_positive 
                                +independence_i_USA 
                                +power_ratUSA_positive*independence_i_USA 
                                +p_polity2 
                                +state_tenure 
                                +factor(issues_new)
                                +cluster(ISO_alpha),data=TAB.USArat)
        summary(Fit.4)
                # no. of countries
                        temp.a <-   subset(TAB.USArat, 
                             is.na(independence_i_USA)==FALSE &
                             is.na(power_ratUSA_positive)==FALSE &
                             is.na(p_polity2)==FALSE &
                             is.na(state_tenure)==FALSE &
                             is.na(issues_new)==FALSE
                            )               
                        length(unique(temp.a$ISO_alpha))
                # period of analysis
                        min(temp.a$stop, na.rm=TRUE)    
                        max(temp.a$stop, na.rm=TRUE)

# Model 5 (US ratifed the same year or a year after)
TAB.select <- subset(TAB, TAB$treaty_abb %in% c("C182","UNFCCC","CUN","PTBT","MP","CITES","VCPOL"))
    
Fit.5 <- coxph( Surv(TAB.select$start,TAB.select$stop,TAB.select$status)~
                                power_ratUSA_positive 
                                +independence_i_USA 
                                +power_ratUSA_positive*independence_i_USA 
                                +p_polity2 
                                +state_tenure 
                                +factor(issues_new)
                                +cluster(ISO_alpha),data=TAB.select)
        summary(Fit.5)
                # no. of countries
                        temp.a <-   subset(TAB.select, 
                             is.na(independence_i_USA)==FALSE &
                             is.na(power_ratUSA_positive)==FALSE &
                             is.na(p_polity2)==FALSE &
                             is.na(state_tenure)==FALSE &
                             is.na(issues_new)==FALSE 
                            )               
                        length(unique(temp.a$ISO_alpha))
                # period of analysis
                        min(temp.a$stop, na.rm=TRUE)    
                        max(temp.a$stop, na.rm=TRUE)

# Model 6 (US ratified later)
TAB.select3 <- subset(TAB, TAB$treaty_abb %in% c("OPCRC","OPIICRC","NPT","TFC","BWC","UNCC","CWC","UNCTOC","PIUNCTOC",
                                                "PIIUNCTOC","TBC", "GC","UNCCD","PVCCWC","CAT","VCDR",
                                                "PIVCCWC","CCWCPIPIII","ICCPR","CERD","C105","CPPCG"))
      
Fit.6 <- coxph( Surv(TAB.select3$start,TAB.select3$stop,TAB.select3$status)~
                                power_ratUSA_positive 
                                +independence_i_USA 
                                +power_ratUSA_positive*independence_i_USA 
                                +p_polity2 
                                +state_tenure 
                                +factor(issues_new)
                                +cluster(ISO_alpha),data=TAB.select3)
        summary(Fit.6)
                # no. of countries
                        temp.a <-   subset(TAB.select3, 
                             is.na(independence_i_USA)==FALSE &
                             is.na(power_ratUSA_positive)==FALSE &
                             is.na(p_polity2)==FALSE &
                             is.na(state_tenure)==FALSE &
                             is.na(issues_new)==FALSE 
                            )               
                        length(unique(temp.a$ISO_alpha))
                # period of analysis
                        min(temp.a$stop, na.rm=TRUE)    
                        max(temp.a$stop, na.rm=TRUE)

#########################################################################################################################
#                                    3D plot                                                                             
#########################################################################################################################
library(lattice)
base <- Fit.3 
base$coefficients

# i-variable 
nam.x1 <- "power_ratUSA_positive"
# j-variable 
nam.x2 <- "independence_i_USA"
nam.x3 <- "power_ratUSA_positive:independence_i_USA"

c1 <- base$coefficients[names(base$coefficients)==nam.x1]
c2 <- base$coefficients[names(base$coefficients)==nam.x2]
c3 <- base$coefficients[names(base$coefficients)==nam.x3]

beta <- c(c1,c2,c3)
was <- seq(0.1,0.9,0.05)
out <- matrix(data = NA, nrow = (length(was)^2), ncol = 8)

HR.Matrix <- matrix(NA, ncol=length(was), nrow=length(was))

x1.nenner <- quantile(TAB.USAnorat[colnames(TAB.USAnorat)==nam.x1], p=0.5, na.rm=TRUE)
x2.nenner <- quantile(TAB.USAnorat[colnames(TAB.USAnorat)==nam.x2], p=0.5, na.rm=TRUE)        

k <- 0
for(i in 1:length(was)){
    x1.zaehler <- quantile(TAB.USAnorat[colnames(TAB.USAnorat)==nam.x1], p=was[i], na.rm=TRUE)            
    for(j in 1:length(was)){
    
        k <- k + 1
        x2.zaehler <- quantile(TAB.USAnorat[colnames(TAB.USAnorat)==nam.x2], p=was[j], na.rm=TRUE)        

        y_zaehler <- exp(c1 * x1.zaehler + c2 * x2.zaehler + c3 * x1.zaehler * x2.zaehler)
        y_nenner  <- exp(c1 * x1.nenner  + c2 * x2.nenner  + c3 * x1.nenner  * x2.nenner)    
        y <- y_zaehler / y_nenner
        
        out[k,1] <- was[i]     
        out[k,2] <- was[j]     
        out[k,3] <- x1.zaehler 
        out[k,4] <- x2.zaehler 
        out[k,5] <- x1.nenner  
        out[k,6] <- x2.nenner  
        out[k,7] <- y          
        out[k,8] <- y_zaehler  
        
        HR.Matrix[i,j] <- y
    
    }    
}

rownames(HR.Matrix) <- was
colnames(HR.Matrix) <- was
HR.Matrix
round(HR.Matrix,2)

grid.tab <- data.frame(out)
test1 <- wireframe(X7~X1*X2, data=grid.tab, 
            xlab=list("Power", cex = 1.28),
            ylab=list("Independence", cex = 1.28),
            zlab=list("Hazard ratio", rot = 90, cex = 1.28),
            main="Model 3",
            colorkey=list(space="right",height= 0.6 , labels=list(cex=1)),
            drape = TRUE, 
            pretty = FALSE,
            aspect= c(1,0.8),
            screen = list(z = -312, x = -63),
            scales = list(arrows = FALSE, distance = c(1.9, 1.69, 1), font = 2),
            par.box=list(col=1),
            par.settings = list(axis.line = list(col = 1))
            )  
print(test1)
trellis.par.get("axis.line")$col

#outfile = paste("D:/CbT-replication/Fit.3.pdf", sep="")
#dev.print(device = pdf, file=outfile)
#outfile = paste("D:/CbT-replication/Fit.3.wmf", sep="")
#dev.print(device = win.metafile, file=outfile) 


########################################################################################################################
#                                      Appendix A. Descriptive statistics                                               
########################################################################################################################
   summary(TAB$power_ratUSA_positive)   
   summary(TAB$tradeshare.gdp)    
   summary(TAB$GDP.curr.USD.million.ln)
   summary(TAB$independence_i_USA)
   summary(TAB$p_polity2_a)
   summary(TAB$p_polity2)
   summary(TAB$europe)
   summary(TAB$state_tenure) 
   summary(TAB$issues_new)                                                                       
   summary(TAB$Rel_muslim)             
   summary(TAB$colonial_1)            
   summary(TAB$regional_norm_lag)     
   summary(TAB$sign_made)

   length(TAB$power_ratUSA_positive[is.na(TAB$power_ratUSA_positive)==FALSE])   
   length(TAB$tradeshare.gdp[is.na(TAB$tradeshare.gdp)==FALSE])    
   length(TAB$GDP.curr.USD.million.ln[is.na(TAB$GDP.curr.USD.million.ln)==FALSE])
   length(TAB$independence_i_USA[is.na(TAB$independence_i_USA)==FALSE])
   length(TAB$p_polity2_a[is.na(TAB$p_polity2_a)==FALSE])
   length(TAB$p_polity2[is.na(TAB$p_polity2)==FALSE])
   length(TAB$europe[is.na(TAB$europe)==FALSE])
   length(TAB$state_tenure[is.na(TAB$state_tenure)==FALSE]) 
   length(TAB$issues_new[is.na(TAB$issues_new)==FALSE])   
   length(TAB$Rel_muslim[is.na(TAB$Rel_muslim)==FALSE])
   length(TAB$colonial_1[is.na(TAB$colonial_1)==FALSE])
   length(TAB$regional_norm_lag[is.na(TAB$regional_norm_lag)==FALSE])
   length(TAB$sign_made[is.na(TAB$sign_made)==FALSE])

   sd(TAB$power_ratUSA_positive, na.rm=TRUE)   
   sd(TAB$tradeshare.gdp, na.rm=TRUE)    
   sd(TAB$GDP.curr.USD.million.ln, na.rm=TRUE)
   sd(TAB$independence_i_USA, na.rm=TRUE)
   sd(TAB$p_polity2_a, na.rm=TRUE)
   sd(TAB$p_polity2, na.rm=TRUE)
   sd(TAB$europe, na.rm=TRUE)
   sd(TAB$state_tenure, na.rm=TRUE) 
   sd(TAB$issues_new, na.rm=TRUE)
   sd(TAB$Rel_muslim, na.rm=TRUE)
   sd(TAB$colonial_1, na.rm=TRUE)
   sd(TAB$regional_norm_lag, na.rm=TRUE)
   sd(TAB$sign_made, na.rm=TRUE)

#########################################################################################################################
#                                 Appendix B. Robustness checks                                                          
#########################################################################################################################

# 1. Adjust data structire only for right-censoring
    TAB$start_n <- TAB$start - TAB$treaty_adopted
    TAB$stop_n <- TAB$stop - TAB$treaty_adopted
    
    summary(TAB$start_n)
    summary(TAB$stop_n)

# 2. Remove MEX and CAN
    TAB$outlier <- 0
    TAB$outlier[TAB$ISO_alpha %in% c("CAN","MEX")] <- 1
    TAB.2 <-subset(TAB, TAB$outlier==0, select=-outlier)
    str(TAB.2, list.len=ncol(TAB.2))     
    
# 3. IATP sample
    IATP.sample  <- c("VCLT",                                                                                 #IATP RoL   (1)  
                      "C100","C105","C111","C138","C182","C87","C98",                                         #IATP Labor (7)  
                      "GC","APGC","APIIGC","OPIICRC","ICRMW",                                                 #IATP HR    (5)  
                      "CERD","ICESCR","ICCPR","OPICCPR","OPIIICCPR","CEDAW","OPCEDAW","CAT","CRC","OPCRC",    #IATP HR    (10) 
                      "CBD","CPCBD","MP","UNFCCC","KPCC","BC","RC","SC","PGRT","UNCCD","UNCLS",               #IATP Env   (11) 
                      "TFC","BWC","CWC","NPT","CTBT","APMC","RSICC")                                          #IATP Sec   (7)  
    TAB.IATP <- subset(TAB, TAB$treaty_abb %in% IATP.sample)              
    sort(unique(TAB.IATP$treaty_abb)) 
    
# 4. Extended model 5 (with economic agreements) - US ratifed the same year or a year after
    TAB.select2 <- subset(TAB.replic, TAB.replic$treaty_abb %in% c("C182","UNFCCC","CUN","PTBT","MP","CITES","VCPOL","WTO","GATT","IMF","IBRD"))
        
    Fit.econ <- coxph( Surv(TAB.select2$start,TAB.select2$stop,TAB.select2$status)~
                                    power_ratUSA_positive 
                                    +independence_i_USA 
                                    +power_ratUSA_positive*independence_i_USA 
                                    +p_polity2 
                                    +state_tenure 
                                    +factor(issues_new)
                                    +cluster(ISO_alpha),data=TAB.select2)
            summary(Fit.econ)
                    # no. of countries
                            temp.a <-   subset(TAB.select2, 
                                is.na(independence_i_USA)==FALSE &
                                is.na(power_ratUSA_positive)==FALSE &
                                is.na(p_polity2)==FALSE &
                                is.na(state_tenure)==FALSE &
                                is.na(issues_new)==FALSE 
                                )               
                            length(unique(temp.a$ISO_alpha))
                    # period of analysis
                            min(temp.a$stop, na.rm=TRUE)    
                            max(temp.a$stop, na.rm=TRUE)   

# 5. Models including other controls and other specifications of the main explanatory variables (based on subsample of US-non-ratfied treaties)

    Fit.A1 <- coxph( Surv(TAB.USAnorat$start,TAB.USAnorat$stop,TAB.USAnorat$status)~
                                    power_ratUSA_positive 
                                    +independence_i_USA 
                                    +power_ratUSA_positive*independence_i_USA 
                                    +p_polity2 
                                    +state_tenure 
                                    +factor(issues_new)
                                    +colonial_1
                                    +Rel_muslim
                                    +cluster(ISO_alpha),data=TAB.USAnorat)
            summary(Fit.A1)
                  # no. of countries
                        temp.a <-   subset(TAB.USAnorat, 
                                is.na(independence_i_USA)==FALSE &
                                is.na(power_ratUSA_positive)==FALSE &
                                is.na(p_polity2)==FALSE &
                                is.na(state_tenure)==FALSE &
                                is.na(issues_new)==FALSE &
                                is.na(+colonial_1)==FALSE &
                                is.na(Rel_muslim)==FALSE
                                )               
                            length(unique(temp.a$ISO_alpha))
                    # period of analysis
                            min(temp.a$stop, na.rm=TRUE)    
                            max(temp.a$stop, na.rm=TRUE) 
    
    
    Fit.A2 <- coxph( Surv(TAB.USAnorat$start,TAB.USAnorat$stop,TAB.USAnorat$status)~
                                    power_ratUSA_positive 
                                    +independence_i_USA 
                                    +power_ratUSA_positive*independence_i_USA 
                                    +p_polity2 
                                    +state_tenure 
                                    +factor(issues_new)
                                    +regional_norm_lag
                                    +cluster(ISO_alpha),data=TAB.USAnorat)
            summary(Fit.A2)
                  # no. of countries
                        temp.a <-   subset(TAB.USAnorat, 
                                is.na(independence_i_USA)==FALSE &
                                is.na(power_ratUSA_positive)==FALSE &
                                is.na(p_polity2)==FALSE &
                                is.na(state_tenure)==FALSE &
                                is.na(issues_new)==FALSE &
                                is.na(regional_norm_lag)==FALSE
                                )               
                            length(unique(temp.a$ISO_alpha))
                    # period of analysis
                            min(temp.a$stop, na.rm=TRUE)    
                            max(temp.a$stop, na.rm=TRUE) 
 
     Fit.A3 <- coxph( Surv(TAB.USAnorat$start,TAB.USAnorat$stop,TAB.USAnorat$status)~
                                    power_ratUSA_positive 
                                    +independence_i_USA 
                                    +power_ratUSA_positive*independence_i_USA 
                                    +p_polity2 
                                    +state_tenure 
                                    +factor(issues_new)
                                    +sign_made
                                    +cluster(ISO_alpha),data=TAB.USAnorat)
            summary(Fit.A3)
                  # no. of countries
                        temp.a <-   subset(TAB.USAnorat, 
                                is.na(independence_i_USA)==FALSE &
                                is.na(power_ratUSA_positive)==FALSE &
                                is.na(p_polity2)==FALSE &
                                is.na(state_tenure)==FALSE &
                                is.na(issues_new)==FALSE &
                                is.na(sign_made)==FALSE
                                )               
                            length(unique(temp.a$ISO_alpha))
                    # period of analysis
                            min(temp.a$stop, na.rm=TRUE)    
                            max(temp.a$stop, na.rm=TRUE) 
    
    
    Fit.A4 <- coxph( Surv(TAB.USAnorat$start,TAB.USAnorat$stop,TAB.USAnorat$status)~
                                    power_ratUSA_positive 
                                    +independence_i_USA 
                                    +power_ratUSA_positive*independence_i_USA 
                                    +p_polity2 
                                    +state_tenure 
                                    +factor(issues_new)
                                    +europe
                                    +cluster(ISO_alpha),data=TAB.USAnorat)
            summary(Fit.A4)
                  # no. of countries
                        temp.a <-   subset(TAB.USAnorat, 
                                is.na(independence_i_USA)==FALSE &
                                is.na(power_ratUSA_positive)==FALSE &
                                is.na(p_polity2)==FALSE &
                                is.na(state_tenure)==FALSE &
                                is.na(issues_new)==FALSE &
                                is.na(europe)==FALSE
                                )               
                            length(unique(temp.a$ISO_alpha))
                    # period of analysis
                            min(temp.a$stop, na.rm=TRUE)    
                            max(temp.a$stop, na.rm=TRUE)
            
    Fit.A5 <- coxph( Surv(TAB.USAnorat$start,TAB.USAnorat$stop,TAB.USAnorat$status)~
                                    power_ratUSA_positive 
                                    +independence_i_USA 
                                    +power_ratUSA_positive*independence_i_USA 
                                    +p_polity2 
                                    +state_tenure 
                                    +factor(issues_new)
                                    +p_polity2_a
                                    +cluster(ISO_alpha),data=TAB.USAnorat)
            summary(Fit.A5)
                  # no. of countries
                        temp.a <-   subset(TAB.USAnorat, 
                                is.na(independence_i_USA)==FALSE &
                                is.na(power_ratUSA_positive)==FALSE &
                                is.na(p_polity2)==FALSE &
                                is.na(state_tenure)==FALSE &
                                is.na(issues_new)==FALSE &
                                is.na(p_polity2_a)==FALSE
                                )               
                            length(unique(temp.a$ISO_alpha))
                    # period of analysis
                            min(temp.a$stop, na.rm=TRUE)    
                            max(temp.a$stop, na.rm=TRUE)   
                            
    Fit.A6 <- coxph( Surv(TAB.USAnorat$start,TAB.USAnorat$stop,TAB.USAnorat$status)~
                                    power_ratUSA_positive 
                                    +tradeshare.gdp 
                                    +power_ratUSA_positive*tradeshare.gdp 
                                    +p_polity2 
                                    +state_tenure 
                                    +factor(issues_new)
                                    +cluster(ISO_alpha),data=TAB.USAnorat)
            summary(Fit.A6)
                  # no. of countries
                        temp.a <-   subset(TAB.USAnorat, 
                                is.na(tradeshare.gdp)==FALSE &
                                is.na(power_ratUSA_positive)==FALSE &
                                is.na(p_polity2)==FALSE &
                                is.na(state_tenure)==FALSE &
                                is.na(issues_new)==FALSE 
                                )               
                            length(unique(temp.a$ISO_alpha))
                    # period of analysis
                            min(temp.a$stop, na.rm=TRUE)    
                            max(temp.a$stop, na.rm=TRUE)          
                            
     Fit.A7 <- coxph( Surv(TAB.USAnorat$start,TAB.USAnorat$stop,TAB.USAnorat$status)~
                                    GDP.curr.USD.million.ln 
                                    +tradeshare.gdp 
                                    +GDP.curr.USD.million.ln*tradeshare.gdp 
                                    +p_polity2 
                                    +state_tenure 
                                    +factor(issues_new)
                                    +cluster(ISO_alpha),data=TAB.USAnorat)
            summary(Fit.A7)
                  # no. of countries
                        temp.a <-   subset(TAB.USAnorat, 
                                is.na(tradeshare.gdp)==FALSE &
                                is.na(GDP.curr.USD.million.ln)==FALSE &
                                is.na(p_polity2)==FALSE &
                                is.na(state_tenure)==FALSE &
                                is.na(issues_new)==FALSE 
                                )               
                            length(unique(temp.a$ISO_alpha))
                    # period of analysis
                            min(temp.a$stop, na.rm=TRUE)    
                            max(temp.a$stop, na.rm=TRUE)                               

############################################################################################################
#                                          6. Simulation                                                    
############################################################################################################

                N.Boot <- 199
                Boot.i<-0
                while(Boot.i<=N.Boot){
                    
                    start.time <- Sys.time()
                    
                    if(Boot.i>0){
                
                        treaty.vec <- sort(unique(TAB.USAnorat$treaty_abb))
                        treaty.sample <- sample(1:length(treaty.vec), size=length(treaty.vec), replace = TRUE)
                        treaty.sample.vec <- treaty.vec[treaty.sample]
                        
                        TAB.sim <- data.frame(treaty=treaty.sample.vec)
                        TAB.sim <- aggregate(rep(1, nrow(TAB.sim)), by=list(TAB.sim$treaty), FUN=sum)
                        colnames(TAB.sim)[1:2] <- c("treaty_abb","n")
                        
                        n.vec <- sort(unique(TAB.sim$n))
                    
                        for(n.i in n.vec){
                        
                            temp <- subset(TAB.sim, TAB.sim$n==n.i, select=-n)
                            temp$bootselect <- 1
                            
                            for(n.j in 1:n.i){
                            
                                TAB.USAnorat.boot.temp <- merge(TAB.USAnorat, temp, all.x=TRUE, all.y=FALSE, by="treaty_abb")
                                TAB.USAnorat.boot.temp <- subset(TAB.USAnorat.boot.temp, TAB.USAnorat.boot.temp$bootselect==1, select=-bootselect)
                                
                                if(n.i==n.vec[1] & n.j==n.i[1]){
                                    TAB.USAnorat.boot <- TAB.USAnorat.boot.temp
                                }else{
                                    TAB.USAnorat.boot <- rbind(TAB.USAnorat.boot, TAB.USAnorat.boot.temp)
                                }
                            
                            }
                            
                        }
                        
                    }else{
                    
                        TAB.USAnorat.boot <- TAB.USAnorat
                    
                    } 
                        
                    if((class(try(
                
                        Fit <- coxph( Surv(start,stop,status)~
                                                power_ratUSA_positive 
                                                +independence_i_USA 
                                                +power_ratUSA_positive*independence_i_USA 
                                                +factor(issues_new)
                                                +p_polity2 +state_tenure 
                                                +cluster(ISO_alpha),data=TAB.USAnorat.boot)
                    
                                        
                                                        
                    ))=="try-error")==FALSE){  
                    
                        temp.coef <- data.frame(summary(Fit)$coefficients)    
                        temp.coef$boot <- Boot.i
                        temp.coef$varname <- rownames(temp.coef)
                        rownames(temp.coef) <- NULL
                        
                        if(Boot.i==0){
                            TAB.coef <- temp.coef
                        }else{
                            TAB.coef <- rbind(TAB.coef, temp.coef)
                        }
                        
                        end.time <- Sys.time()
                        duration.time <- end.time - start.time
                        
                        cat("Simulation ", Boot.i, " of ", N.Boot, " |  Duration ", duration.time, "\n")
                        
                        Boot.i <- Boot.i + 1
                        
                    }
                    
                write.csv(TAB.coef, file="D:/CbT-replication/TAB_Simulation_Fit.3.csv", row.names=FALSE)
                write.csv2(TAB.coef, file="D:/CbT-replication/TAB_Simulation2_Fit.3.csv", row.names=FALSE) 
                    
                } 

TAB.Result <- read.csv(file="D:/CbT-replication/TAB_Simulation_Fit.3.csv")
Var.Nam.vec <- c("power_ratUSA_positive:independence_i_USA","power_ratUSA_positive","independence_i_USA") 

i <- 3
 

for(i in 1:length(Var.Nam.vec)){
    
    Var.Nam.i <- Var.Nam.vec[i]
    coef.est <- TAB.Result$coef[TAB.Result$varname==Var.Nam.i & TAB.Result$boot==0]    
    coef.values <- TAB.Result$coef[TAB.Result$varname==Var.Nam.i & TAB.Result$boot!=0 & is.na(TAB.Result$coef)==FALSE]
    coef.mean <- mean(coef.values)
    coef.max <- max(coef.values)    
    coef.min <- min(coef.values)            
    coef.median <- median(coef.values)
    coef.P.0.05 <- quantile(coef.values, probs = 0.05, na.rm = TRUE)
    coef.P.0.95 <- quantile(coef.values, probs = 0.95, na.rm = TRUE)
    coef.P.0.025 <- quantile(coef.values, probs = 0.025, na.rm = TRUE)
    coef.P.0.975 <- quantile(coef.values, probs = 0.975, na.rm = TRUE)
    coef.robust.se <- TAB.Result$robust.se[TAB.Result$varname==Var.Nam.i & TAB.Result$boot==0]
    coef.ci.95.up <- coef.est + qt(p=(1-0.05/2), df=Inf) * coef.robust.se
    coef.ci.95.lo <- coef.est - qt(p=(1-0.05/2), df=Inf) * coef.robust.se    
    
    coef.se <- TAB.Result$se.coef.[TAB.Result$varname==Var.Nam.i & TAB.Result$boot==0]
    coef.sd <- sd(coef.values)
    
    plot.range <- max(abs(c(coef.max,coef.min)))
    
    TAB.density <- density(coef.values)

    y.max <- max(TAB.density$y, na.rm=TRUE)
    
    par(mfrow=c(1,1), mar=c(3,0.5,3,0.5)
        , family="mono", cex=1.5, yaxt="n", xaxt="s")

    plot(NULL, NULL, xlim=c(-plot.range,plot.range), ylim=c(0,y.max),  main=Var.Nam.i, xlab="", ylab="")
    
    points(TAB.density$x, TAB.density$y, type="l", lwd=2, lty=1)
    
    abline(v=coef.mean, lty=1, lwd=1, col=gray(0.6))
    abline(v=coef.median, lty=2, lwd=1, col=gray(0.6))
    abline(v=coef.est,  lty=1, lwd=1, col=1)       
    
    abline(v=coef.P.0.025,  lty=2, lwd=1, col=1)
    abline(v=coef.P.0.975,  lty=2, lwd=1, col=1)
    
    legend("topleft",
           legend=c("estimate","mean","median","95% intv."), 
           lty=c(1,1,2,2),
           lwd=c(1,1,1,1), 
           col=c(1,gray(0.6),gray(0.6),1),
           bty = "n",            
           cex = 1                                  
    )    
   
    Var.Nam.i.File <- gsub(pattern=":", replacement="_", x=Var.Nam.i)
        
    dev.print(device=pdf, file=paste("D:/CbT-replication/",Var.Nam.i.File ,".pdf",sep=""))                    
    dev.print(device=win.metafile, file=paste("D:/CbT-replication/",Var.Nam.i.File ,".wmf",sep=""))

}

##########################################################################################################################
#                                             Correlation matrix                                                          
##########################################################################################################################
TAB.temp <- subset(TAB, select=c("ISO_alpha","stop.trunc","power_ratUSA_positive","independence_i_USA","p_polity2","p_polity2_a",
                                          "state_tenure","europe","GDP.curr.USD.million.ln","tradeshare.gdp","cinc","regional_norm_lag","sign_made"
                                           ))                                               
TAB.temp <- data.frame(unique(cbind(TAB.temp$ISO_alpha,
                                    TAB.temp$stop.trunc,
                                    TAB.temp$power_ratUSA_positive,
                                    TAB.temp$independence_i_USA,
                                    TAB.temp$p_polity2,
                                    TAB.temp$p_polity2_a,
                                    TAB.temp$state_tenure,
                                    TAB.temp$europe,
                                    TAB.temp$GDP.curr.USD.million.ln,
                                    TAB.temp$tradeshare.gdp,
                                    TAB.temp$cinc,
                                    TAB.temp$regional_norm_lag,
                                    TAB.temp$sign_made
                                    )))
                                    
colnames(TAB.temp)[1:ncol(TAB.temp)] <- c("ISO_alpha","stop.trunc","power_ratUSA_positive","independence_i_USA","p_polity2","p_polity2_a",
                                          "state_tenure","europe","GDP.curr.USD.million.ln","tradeshare.gdp","cinc","regional_norm_lag","sign_made")                                                
TAB.temp$ISO_alpha <- as.character(TAB.temp$ISO_alpha)

for(i in 2:ncol(TAB.temp)){
    TAB.temp[,i] <- as.numeric(as.character(TAB.temp[,i]))
}

temp <- subset(TAB.temp, 
            is.na(TAB.temp$power_ratUSA_positive)==FALSE & 
            is.na(TAB.temp$independence_i_USA)==FALSE & 
            is.na(TAB.temp$p_polity2)==FALSE & 
            is.na(TAB.temp$p_polity2_a)==FALSE & 
            is.na(TAB.temp$state_tenure)==FALSE & 
            is.na(TAB.temp$europe)==FALSE & 
            is.na(TAB.temp$GDP.curr.USD.million.ln)==FALSE & 
            is.na(TAB.temp$tradeshare.gdp)==FALSE & 
            is.na(TAB.temp$cinc)==FALSE & 
            is.na(TAB.temp$regional_norm_lag)==FALSE &
            is.na(TAB.temp$sign_made)==FALSE  ,        
select=c("power_ratUSA_positive","independence_i_USA","p_polity2","p_polity2_a",
         "state_tenure","europe","GDP.curr.USD.million.ln","tradeshare.gdp","cinc","regional_norm_lag","sign_made"))
cor(temp)
